<?php
namespace Import\ApiBundle\Services\Api;


use Import\ApiBundle\Entity\GpwIndex;
use Import\ApiBundle\Entity\GpwType;
use Import\ApiBundle\Entity\NewConnect;

class ApiGetMethods extends ApiBasicMethods
{
    protected function getIndexGPWBySymbol($symbol, $add = true)
    {
        $IndexGPW = $this->getDoctrine()->getRepository('ImportApiBundle:IndexGPW')->findOneBySymbol($symbol);
        if(empty($IndexGPW) && $add)
        {
            $IndexGPW = $this->getDoctrine()->getRepository('ImportApiBundle:IndexGPW')->add(array('symbol'=>$symbol));
        }

        return $IndexGPW;
    }

    protected function getCurrencyBySymbol($symbol, $add = true)
    {
        $Currency = $this->getDoctrine()->getRepository('ImportApiBundle:Currency')->findOneBySymbol($symbol);
        if(empty($Currency) && $add)
        {
            $Currency = $this->getDoctrine()->getRepository('ImportApiBundle:Currency')->add(array('symbol'=>$symbol));
        }

        return $Currency;
    }

    protected function getInvestmentFundsBySymbol($symbol, $add = true)
    {
        $IndexGPW = $this->getDoctrine()->getRepository('ImportApiBundle:InvestmentFunds')->findOneBySymbol($symbol);
        if(empty($IndexGPW) && $add)
        {
            $IndexGPW = $this->getDoctrine()->getRepository('ImportApiBundle:InvestmentFunds')->add(array('symbol'=>$symbol));
        }

        return $IndexGPW;
    }

    /**
     * @param $symbol
     * @param bool $add
     * @return GpwIndex
     */
    protected function getGpwIndexBySymbol(GpwType $GpwType, $symbol, $add = true)
    {
        $GpwIndex = $this->getDoctrine()->getRepository('ImportApiBundle:GpwIndex')->findOneBySymbol($symbol);
        if(empty($GpwIndex) && $add)
        {
            $GpwIndex = $this->getDoctrine()->getRepository('ImportApiBundle:GpwIndex')->add(array('symbol'=>$symbol,'GpwType'=>$GpwType));
        }

        return $GpwIndex;
    }

    /**
     * @return mixed
     */
    protected function getGpwTypeAll()
    {
        return $this->getDoctrine()->getEntityManager()->getRepository('ImportApiBundle:GpwType')->findAll();
    }

    //------------------------------------------------------ALLEGRO----------------------------------------------------

    protected function getAllegroCategoryItemType($name)
    {
        $defaultName = "Inne";
        $AllegroCategoryItemTypeRepository = $this->getDoctrine()->getRepository('ImportApiBundle:AllegroCategoryItemType');

        $AllegroCategoryItemType = $AllegroCategoryItemTypeRepository->findOneByName($name);
        if(empty($AllegroCategoryItemType))
        {
            $AllegroCategoryItemType = $AllegroCategoryItemTypeRepository->findOneByName($defaultName);
        }

        return $AllegroCategoryItemType;
    }
}
